#include <iostream>
#include <cmath>
#include <vector>
#include <algorithm>
#include <cassert>

using namespace std;

int calc(int n, int p = 15)
{
    int res = 2 * n * p;
    if (n != 1)
    {
        res += calc(n / 2, p - 1);
        res += calc((n + 1) / 2, p - 1);
    }
    return res;
}

int main()
{
    cin.tie(0)->sync_with_stdio(0);
    int n;
    cin >> n;
    vector<int> a(n);
    for (int &i : a) cin >> i;
    vector<int> help = a;
    sort(help.begin(), help.end());
    vector<int> cnt(100000, 0);
    for (int i = 0; i < n; ++i)
    {
        auto it = lower_bound(help.begin(), help.end(), a[i]);
        int d = distance(help.begin(), it);
        int na = d + cnt[a[i]];
        ++cnt[a[i]];
        a[i] = na;
    }
    vector<pair<int, int>> ops;
    auto merge = [&ops, &a](auto self, int l, int r) -> void
    {
        if (l == r) return;
        if (l + 1 == r)
        {
            if (a[l] > a[r])
            {
                swap(a[l], a[r]);
                ops.emplace_back(l, r);
            }
            return;
        }
        int m = (l + r) >> 1;
        if (a[m + 1] >= a[m]) return;
        vector<int> help;
        for (int i = l; i <= r; ++i) help.push_back(a[i]);
        sort(help.begin(), help.end());
        int sz = (int)help.size();
        int pivot = help[(sz - 1) / 2];
        int cnt = 0;
        for (int i = m + 1; i <= r; ++i)
        {
            if (a[i] <= pivot)
            {
                cnt = i - m;
            }
            else break;
        }
        ops.emplace_back(m - cnt + 1, m + cnt);
        if (cnt != 1) ops.emplace_back(m - cnt + 1, m);
        if (cnt != 1) ops.emplace_back(m + 1, m + cnt);
        for (int i = m - cnt + 1; i <= m; ++i)
        {
            swap(a[i], a[i + cnt]);
        }
        self(self, l, m);
        self(self, m + 1, r);
    };
    auto mergeSort = [&ops, &a, &merge](auto self, int l, int r) -> void
    {
        if (l == r) return;
        if (l + 1 == r)
        {
            if (a[l] > a[r])
            {
                swap(a[l], a[r]);
                ops.emplace_back(l, r);
                return;
            }
        }
        int m = (l + r) >> 1;
        self(self, l, m);
        self(self, m + 1, r);
        merge(merge, l, r);
    };
    mergeSort(mergeSort, 0, n - 1);
    cout << ops.size() << '\n';
    assert(ops.size() <= 1e8);
    for (auto [a, b] : ops) cout << a + 1 << ' ' << b + 1 << '\n';
    /*int sum = calc(32000);
    cout << sum << '\n';
    cout << pow(1 - (sum - 2e6) / (512 * 2e6), 10) * 10;
    //511984000
    //512000000
    //n log^2 n*/
    return 0;
}
//4 5 6 1 2 3
